
// latin alphabet + extras
char[] letters = { 'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z',' ' };

// quaternary triplets
String[] quaternaries = { "000","001","002","003","010","011","012","013","020","021","022","023","030","031","032","033","100","101","102","103","110","111","112","113","120","121","122","123","130","131","132","133","200","201","202","203","210","211","212","213","220","221","222","223","230","231","232","233","300","301","302","303","310","311","312","313","320","321","322","323","330","331","332","333" };

// DNA base letters (has to map quaternary triplets)
char[] bases = { 'A', 'C', 'T', 'G' };


String inputText = "";
String inputQuatEncoded = "";
String inputDNAEncoded = "";

int tileSize, tilePosX, tilePosY;
PFont prettyFont;

void setup() {  
  size(600, 600);
  

  /* styling */
  textSize(10);
  tileSize = 20;
  tilePosX = 20;
  tilePosY = height/5;  
  
  prettyFont = createFont("Moderat-Regular.otf", 16);
  textFont(prettyFont);
}


void draw() {
  
  background(30);
  fill(255);
  
  text( inputText, 20, 40 );
  text( inputQuatEncoded, 20, 80 );
  
  noStroke();
  tilePosX = 20;
  tilePosY = height/4;  
  for ( var i = 0; i < inputDNAEncoded.length(); i++ ) {
    if ( inputDNAEncoded.charAt(i) == 'A' ) {
      fill(#4284C7);
    } else if ( inputDNAEncoded.charAt(i) == 'C' ) {
      fill(#CB343B);
    } else if ( inputDNAEncoded.charAt(i) == 'T' ) {
      fill(#38CB3F);
    } else if ( inputDNAEncoded.charAt(i) == 'G' ) {
      fill(#E2CF5C);
    } else if ( inputDNAEncoded.charAt(i) == ' ' ) {
      noFill();
    }
    rect( tilePosX, tilePosY, tileSize, tileSize );
    fill(255);
    text(inputDNAEncoded.charAt(i), tilePosX +5, tilePosY +15);
    
    if ( tilePosX + tileSize < width -40 ) {
      tilePosX += tileSize;
    } else {
      tilePosX = 20;
      tilePosY += 40;
    }
  }
  
  
}



void keyPressed() {
    
  if ( keyCode == 8 ) {
    inputText = "";
    inputQuatEncoded = "";
    inputDNAEncoded = "";    
  }  
}




void keyTyped() {
  String inputKey = "" + key;
  inputKey = inputKey.toUpperCase();
  
  for ( int i = 0; i < letters.length; i++ ) {
    if ( inputKey.charAt(0) == letters[i] ) {
      inputText += inputKey;
      
      inputQuatEncoded += quaternaries[i];
      inputQuatEncoded += " ";
      
      String tempDNAEncoded = "";
      for ( int j = 0; j < quaternaries[i].length(); j++ ) {
        tempDNAEncoded += bases[Character.getNumericValue( quaternaries[i].charAt(j) )];
      }
      inputDNAEncoded += tempDNAEncoded;
      inputDNAEncoded += " ";
    }
  }
  
  
  if ( int(key) == 10 ) {
    println( inputDNAEncoded.replace(" ", "") );
  }
  
}
